

<?php

$moduleName = __('root.cr_voucher.cr_voucher_manage');
$createItemName = __('root.common.edit') . ' ' . $moduleName;

$breadcrumbMainName = $moduleName;
$breadcrumbCurrentName = ' ' . __('root.common.edit');

$breadcrumbMainIcon = 'account_balance_wallet';
$breadcrumbCurrentIcon = 'archive';

$ModelName = 'App\Transaction';
$ParentRouteName = 'cr_voucher';

?>
<?php $__env->startSection('title'); ?>
    <?php echo e($moduleName); ?>-><?php echo e($createItemName); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('top-bar'); ?>
    <?php echo $__env->make('includes.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('left-sidebar'); ?>
    <?php echo $__env->make('includes.left-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section <?php if($is_rtl): ?> dir="rtl" <?php endif; ?> class="content">
        <div class="container-fluid">
            <div class="block-header <?php if($is_rtl): ?> pull-right <?php else: ?> pull-left <?php endif; ?>">
                <a class="btn btn-sm btn-info waves-effect" href="<?php echo e(url()->previous()); ?>"><?php echo e(__('root.common.back')); ?></a>
            </div>
            <ol class="breadcrumb breadcrumb-col-cyan <?php if($is_rtl): ?> pull-left  <?php else: ?> pull-right <?php endif; ?>">
                <li><a href="<?php echo e(route($ParentRouteName)); ?>"><i class="material-icons">home</i> <?php echo e(__('root.common.home')); ?></a></li>
                <li><a href="<?php echo e(route($ParentRouteName)); ?>"><i
                            class="material-icons"><?php echo e($breadcrumbMainIcon); ?></i>&nbsp;<?php echo e($breadcrumbMainName); ?></a>
                </li>
                <li class="active"><i class="material-icons"><?php echo e($breadcrumbCurrentIcon); ?></i>&nbsp; <?php echo e($breadcrumbCurrentName); ?>

                </li>
            </ol>
            <!-- Inline Layout | With Floating Label -->
            <div class="row clearfix">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="header">
                            <h2 class="m-b-20">
                                <?php echo e($createItemName); ?>

                                <small>Edit <?php echo e($moduleName); ?> Information</small>
                            </h2>
                            <div class="body">
                                <form class="form" id="form_validation" method="post"
                                    action="<?php echo e(route($ParentRouteName . '.update', ['id' => $item[0]->voucher_no])); ?>">
                                    <?php echo e(csrf_field()); ?>

                                    <div class="row clearfix">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true" class="form-control show-tick"
                                                        name="branch_id">
                                                        <option value="0">Select Branch Name</option>
                                                        <?php $__currentLoopData = $branches->sortByDesc('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option
                                                                <?php if($branch->id == $item[0]->branch_id): ?> )
                                                                        selected <?php endif; ?>
                                                                value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true" class="form-control show-tick"
                                                        name="bank_cash_id" id="">
                                                        <option value="0"> Select Bank Cash Name</option>
                                                        <?php $__currentLoopData = $bank_cashes->sortByDesc('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank_cash): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option
                                                                <?php if($bank_cash->id == $item[0]->bank_cash_id): ?> )
                                                                        selected <?php endif; ?>
                                                                value="<?php echo e($bank_cash->id); ?>"><?php echo e($bank_cash->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <input value="<?php echo e($item[0]->cheque_number); ?>" name="cheque_number"
                                                        type="text" class="form-control">
                                                    <label class="form-label">Cheque Number</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row dr">
                                        <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true"
                                                        class="form-control show-tick income_expense_head_id"
                                                        name="income_expense_head_id[]" id="">
                                                        <option value="0"> Select Head of Account Name</option>
                                                        <?php $__currentLoopData = $income_expense_heads->sortByDesc('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $HeadOfAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if($HeadOfAccount->id == $item[0]->income_expense_head_id): ?> selected <?php endif; ?>
                                                                value="<?php echo e($HeadOfAccount->id); ?>">
                                                                <?php echo e($HeadOfAccount->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <input value="<?php echo e($item[0]->amount); ?>" name="amount[]" type="number"
                                                        class="form-control amount">
                                                    <label class="form-label">Amount </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 col-md-1 col-sm-1 col-xs-1 field_area">
                                            <div class="form-group form-float">
                                                <i
                                                    class="pointer-cursor material-icons text-success plus">add_circle_outline</i>

                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!empty($item[1]->income_expense_head_id)): ?>
                                        <?php $headOfAccountID1 = $item[1]->income_expense_head_id; ?>
                                    <?php else: ?>
                                        <?php $headOfAccountID1 = ''; ?>
                                    <?php endif; ?>
                                    <?php if(!empty($item[1]->amount)): ?>
                                        <?php $amount1 = $item[1]->amount; ?>
                                    <?php else: ?>
                                        <?php $amount1 = ''; ?>
                                    <?php endif; ?>
                                    <div class="row dr">
                                        <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true"
                                                        class="form-control show-tick income_expense_head_id"
                                                        name="income_expense_head_id[]" id="">
                                                        <option value="0"> Select Head of Account Name</option>
                                                            <?php $__currentLoopData = $income_expense_heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $HeadOfAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php if($HeadOfAccount->id == $headOfAccountID1): ?> selected <?php endif; ?>
                                                                    value="<?php echo e($HeadOfAccount->id); ?>">
                                                                    <?php echo e($HeadOfAccount->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <input value="<?php echo e($amount1); ?>" name="amount[]" type="number"
                                                        class="form-control amount">
                                                    <label class="form-label">Amount </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 col-md-1 col-sm-1 col-xs-1 field_area">
                                            <div class="form-group form-float">
                                                <i
                                                    class="pointer-cursor material-icons text-success plus">add_circle_outline</i>
                                                <i
                                                    class="pointer-cursor material-icons text-danger minus">remove_circle_outline</i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!empty($item[2]->income_expense_head_id)): ?>
                                        <?php $headOfAccountID2 = $item[2]->income_expense_head_id; ?>
                                    <?php else: ?>
                                        <?php $headOfAccountID2 = ''; ?>
                                    <?php endif; ?>
                                    <?php if(!empty($item[2]->amount)): ?>
                                        <?php $amount2 = $item[2]->amount; ?>
                                    <?php else: ?>
                                        <?php $amount2 = ''; ?>
                                    <?php endif; ?>
                                    <div class="row dr">
                                        <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true"
                                                        class="form-control show-tick income_expense_head_id"
                                                        name="income_expense_head_id[]" id="">
                                                        <option value="0"> Select Head of Account Name</option>
                                                        <?php $__currentLoopData = $income_expense_heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $HeadOfAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if($HeadOfAccount->id == $headOfAccountID2): ?> selected <?php endif; ?>
                                                                value="<?php echo e($HeadOfAccount->id); ?>">
                                                                <?php echo e($HeadOfAccount->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <input value="<?php echo e($amount2); ?>" name="amount[]" type="number"
                                                        class="form-control amount">
                                                    <label class="form-label">Amount </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 col-md-1 col-sm-1 col-xs-1 field_area">
                                            <div class="form-group form-float">
                                                <i
                                                    class="pointer-cursor material-icons text-success plus">add_circle_outline</i>
                                                <i
                                                    class="pointer-cursor material-icons text-danger minus">remove_circle_outline</i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!empty($item[3]->income_expense_head_id)): ?>
                                        <?php $headOfAccountID3 = $item[3]->income_expense_head_id; ?>
                                    <?php else: ?>
                                        <?php $headOfAccountID3 = ''; ?>
                                    <?php endif; ?>
                                    <?php if(!empty($item[3]->amount)): ?>
                                        <?php $amount3 = $item[3]->amount; ?>
                                    <?php else: ?>
                                        <?php $amount3 = ''; ?>
                                    <?php endif; ?>
                                    <div class="row dr">
                                        <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true"
                                                        class="form-control show-tick income_expense_head_id"
                                                        name="income_expense_head_id[]" id="">
                                                        <option value="0"> Select Head of Account Name</option>
                                                        <?php $__currentLoopData = $income_expense_heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $HeadOfAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if($HeadOfAccount->id == $headOfAccountID3): ?> selected <?php endif; ?>
                                                                value="<?php echo e($HeadOfAccount->id); ?>">
                                                                <?php echo e($HeadOfAccount->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <input value="<?php echo e($amount3); ?>" name="amount[]" type="number"
                                                        class="form-control amount">
                                                    <label class="form-label">Amount </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 col-md-1 col-sm-1 col-xs-1 field_area">
                                            <div class="form-group form-float">
                                                <i
                                                    class="pointer-cursor material-icons text-success plus">add_circle_outline</i>
                                                <i
                                                    class="pointer-cursor material-icons text-danger minus">remove_circle_outline</i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!empty($item[4]->income_expense_head_id)): ?>
                                        <?php $headOfAccountID4 = $item[4]->income_expense_head_id; ?>
                                    <?php else: ?>
                                        <?php $headOfAccountID4 = ''; ?>
                                    <?php endif; ?>
                                    <?php if(!empty($item[4]->amount)): ?>
                                        <?php $amount4 = $item[4]->amount; ?>
                                    <?php else: ?>
                                        <?php $amount4 = ''; ?>
                                    <?php endif; ?>
                                    <div class="row dr">
                                        <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <select data-live-search="true"
                                                        class="form-control show-tick income_expense_head_id"
                                                        name="income_expense_head_id[]" id="">
                                                        <option value="0"> Select Head of Account Name</option>
                                                        <?php $__currentLoopData = $income_expense_heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $HeadOfAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if($HeadOfAccount->id == $headOfAccountID4): ?> selected <?php endif; ?>
                                                                value="<?php echo e($HeadOfAccount->id); ?>">
                                                                <?php echo e($HeadOfAccount->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <input value="<?php echo e($amount4); ?>" name="amount[]" type="number"
                                                        class="form-control amount">
                                                    <label class="form-label">Amount </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 col-md-1 col-sm-1 col-xs-1 field_area">
                                            <div class="form-group form-float">
                                                <i
                                                    class="pointer-cursor material-icons text-danger minus">remove_circle_outline</i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line" id="bs_datepicker_container">
                                                    <input autocomplete="off"
                                                        value="<?php echo e(date('m/d/Y', strtotime($item[0]->voucher_date))); ?>"
                                                        name="voucher_date" type="text" class="form-control"
                                                        placeholder="Please choose a date...">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 field_area">
                                            <div class="form-group form-float">
                                                <div class="form-line">
                                                    <textarea name="particulars" rows="2" class="form-control no-resize" placeholder="Particulars"><?php echo e($item[0]->particulars); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="form-line">
                                                <button type="submit" class="btn btn-primary m-t-15 waves-effect">
                                                    <?php echo e(__('root.common.update')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- #END# Inline Layout | With Floating Label -->
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('include-css'); ?>
    <!-- Bootstrap Select Css -->
    <link href="<?php echo e(asset('asset/plugins/bootstrap-select/css/bootstrap-select.css')); ?>" rel="stylesheet" />

    <!-- Bootstrap Material Datetime Picker Css -->
    <link href="<?php echo e(asset('asset/plugins/bootstrap-material-datetimepicker/css/bootstrap-material-datetimepicker.css')); ?>"
        rel="stylesheet" />
    <!-- Bootstrap DatePicker Css -->
    <link href="<?php echo e(asset('asset/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('include-js'); ?>
    <!-- Moment Plugin Js -->
    <script src="<?php echo e(asset('asset/plugins/momentjs/moment.js')); ?>"></script>
    <!-- Bootstrap Material Datetime Picker Plugin Js -->
    <script src="<?php echo e(asset('asset/plugins/bootstrap-material-datetimepicker/js/bootstrap-material-datetimepicker.js')); ?>">
    </script>
    <!-- Bootstrap Datepicker Plugin Js -->
    <script src="<?php echo e(asset('asset/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js')); ?>"></script>
    <!-- Autosize Plugin Js -->
    <script src="<?php echo e(asset('asset/plugins/autosize/autosize.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/js/pages/forms/basic-form-elements.js')); ?>"></script>
    <script>
        <?php if(Session::has('success')): ?>
            toastr["success"]('<?php echo e(Session::get('success')); ?>');
        <?php endif; ?>
        <?php if(Session::has('error')): ?>
            toastr["error"]('<?php echo e(Session::get('error')); ?>');
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                toastr["error"]('<?php echo e($error); ?>');
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        // Validation and calculation on Cr Voucher
        var UiController = (function() {
            var DOMString = {
                submit_form: 'form.form',
                field_area: '.field_area',
                project_id: 'select[name=branch_id]',
                bankcash_id: 'select[name=bank_cash_id]',
                cheque_number: 'input[name=cheque_number]',
                head_of_account_id: '.income_expense_head_id',
                amount: '.amount',
                date: 'input[name=voucher_date]',
                particulars: 'textarea[name=particulars]',
                drCloset: '.dr',
                dr: 'dr',
                plus: 'plus',
                minus: 'minus',
            };
            return {
                getDOMString: function() {
                    return DOMString;
                },
                getFields: function() {
                    return {
                        get_form: document.querySelector(DOMString.submit_form),
                        get_project_id: document.querySelector(DOMString.project_id),
                        get_bankcash_id: document.querySelector(DOMString.bankcash_id),
                        get_cheque_number: document.querySelector(DOMString.cheque_number),
                        get_head_of_account_id: document.querySelectorAll(DOMString.head_of_account_id),
                        get_amount: document.querySelectorAll(DOMString.amount),
                        get_date: document.querySelector(DOMString.date),
                        get_particulars: document.querySelector(DOMString.particulars),
                        get_dr: document.getElementsByClassName(DOMString.dr),
                        get_plus: document.getElementsByClassName(DOMString.plus),
                        get_minus: document.getElementsByClassName(DOMString.minus),
                    }
                },
                getValues: function() {
                    var Fields = this.getFields();
                    return {
                        project_id: Fields.get_project_id.value == "" ? 0 : parseFloat(Fields.get_project_id
                            .value),
                        bankcash_id: Fields.get_bankcash_id.value == "" ? 0 : parseFloat(Fields.get_bankcash_id
                            .value),
                        cheque_number: Fields.get_cheque_number.value == "" ? 0 : parseFloat(Fields
                            .get_cheque_number.value),
                        date: Fields.get_date.value == "" ? 0 : Fields.get_date.value,
                        particulars: Fields.get_particulars.value == "" ? 0 : Fields.get_particulars.value,
                    }
                },
                hide: function(Field) {
                    var DomString = this.getDOMString();
                    var Area = Field.closest(DomString.field_area);
                    if (Area) {
                        Area.style.display = 'none';
                    }
                },
                show: function(Field) {
                    var DomString = this.getDOMString();
                    var Area = Field.closest(DomString.field_area);
                    if (Area) {
                        Area.style.display = 'block';
                    }
                },
                hideHeadAmountArea: function(Field) {
                    if (Field) {
                        Field.style.display = 'none';
                    }
                },
                showHeadAmountArea: function(Field) {
                    var DomString = this.getDOMString();
                    if (Field) {
                        Field.style.display = 'block';
                    }
                },
                setZero: function(Field) {
                    Field.value = 0;
                },
                setEmpty: function(Field) {
                    Field.value = "";
                },
            }
        })();
        var MainController = (function(UICnt) {
            var DOMString = UICnt.getDOMString();
            var Fields = UICnt.getFields();
            var setUpEventListner = function() {
                Fields.get_form.addEventListener('submit', validation);
                Fields.get_bankcash_id.addEventListener('change', bankcashChange);
                Array.prototype.forEach.call(Fields.get_plus, function(plus, index) {
                    plus.addEventListener('click', function() {
                        addItem(index);
                    }, false);
                });
                Array.prototype.forEach.call(Fields.get_minus, function(minus, index) {
                    minus.addEventListener('click', function() {
                        removeItem(index);
                    }, false);
                });
            };
            var validation = function(e) {
                var Values, Fields;
                Values = UICnt.getValues();
                Fields = UICnt.getFields();
                if (Values.project_id == 0) {
                    toastr["error"]('Select  Project');
                    e.preventDefault();
                }
                if (Values.bankcash_id == 0) {
                    toastr["error"]('Select Bank Cash Name');
                    e.preventDefault();
                }
                if (Fields.get_head_of_account_id[0].querySelector('select').value == 0) {
                    toastr["error"]('Select Head Of Account');
                    e.preventDefault();
                }
                if (Fields.get_amount[0].value == '') {
                    toastr["error"]('Put Amount');
                    e.preventDefault();
                }
                if (Values.date == 0) {
                    toastr["error"]('Set Date');
                    e.preventDefault();
                }
                if (Fields.get_dr[1].style.display == 'block') {
                    if (Fields.get_head_of_account_id[2].querySelector('select').value == 0) {
                        toastr["error"]('Select Head Of Account');
                        e.preventDefault();
                    }
                    if (Fields.get_amount[1].value == '') {
                        toastr["error"]('Put Amount');
                        e.preventDefault();
                    }
                }
                if (Fields.get_dr[2].style.display == 'block') {
                    if (Fields.get_head_of_account_id[4].querySelector('select').value == 0) {
                        toastr["error"]('Select Head Of Account');
                        e.preventDefault();
                    }
                    if (Fields.get_amount[2].value == '') {
                        toastr["error"]('Put Amount');
                        e.preventDefault();
                    }
                }
                if (Fields.get_dr[3].style.display == 'block') {
                    if (Fields.get_head_of_account_id[6].querySelector('select').value == 0) {
                        toastr["error"]('Select Head Of Account');
                        e.preventDefault();
                    }
                    if (Fields.get_amount[3].value == '') {
                        toastr["error"]('Put Amount');
                        e.preventDefault();
                    }
                }
                if (Fields.get_dr[4].style.display == 'block') {
                    if (Fields.get_head_of_account_id[8].querySelector('select').value == 0) {
                        toastr["error"]('Select Head Of Account');
                        e.preventDefault();
                    }
                    if (Fields.get_amount[4].value == '') {
                        toastr["error"]('Put Amount');
                        e.preventDefault();
                    }
                }
                var head_of_account_Ids = [];
                var get_head_of_account_id_one = Fields.get_head_of_account_id[0].querySelector('select')
                    .value == "" ? 0 : parseFloat(Fields.get_head_of_account_id[0].querySelector('select')
                        .value);
                var get_head_of_account_id_two = Fields.get_head_of_account_id[2].querySelector('select')
                    .value == "" ? 0 : parseFloat(Fields.get_head_of_account_id[2].querySelector('select')
                        .value);
                var get_head_of_account_id_three = Fields.get_head_of_account_id[4].querySelector('select')
                    .value == "" ? 0 : parseFloat(Fields.get_head_of_account_id[4].querySelector('select')
                        .value);
                var get_head_of_account_id_four = Fields.get_head_of_account_id[6].querySelector('select')
                    .value == "" ? 0 : parseFloat(Fields.get_head_of_account_id[6].querySelector('select')
                        .value);
                var get_head_of_account_id_five = Fields.get_head_of_account_id[8].querySelector('select')
                    .value == "" ?
                    0 : parseFloat(Fields.get_head_of_account_id[8].querySelector('select').value);

                if (get_head_of_account_id_one > 0) {
                    head_of_account_Ids.push(get_head_of_account_id_one);
                }
                if (get_head_of_account_id_two > 0) {
                    head_of_account_Ids.push(get_head_of_account_id_two);
                }
                if (get_head_of_account_id_three > 0) {
                    head_of_account_Ids.push(get_head_of_account_id_three);
                }
                if (get_head_of_account_id_four > 0) {
                    head_of_account_Ids.push(get_head_of_account_id_four);
                }
                if (get_head_of_account_id_five > 0) {
                    head_of_account_Ids.push(get_head_of_account_id_five);
                }

                function checkUniqueOrNot(head_of_account_Ids) {
                    var counts = [];
                    for (var i = 0; i <= head_of_account_Ids.length; i++) {
                        if (counts[head_of_account_Ids[i]] === undefined) {
                            counts[head_of_account_Ids[i]] = 1;
                        } else {
                            return true;
                        }
                    }
                    return false;
                }

                if (checkUniqueOrNot(head_of_account_Ids)) {
                    toastr["error"]('Head of Account should unique');
                    e.preventDefault();
                }
            };
            var bankcashChange = function() {
                var Values, Fields;
                Values = UICnt.getValues();
                Fields = UICnt.getFields();

                if (Values.bankcash_id <= 1) {
                    UICnt.hide(Fields.get_cheque_number);
                } else {
                    UICnt.show(Fields.get_cheque_number);
                }
            };
            var addItem = function(index) {
                var Fields;
                Fields = UICnt.getFields();
                UICnt.showHeadAmountArea(Fields.get_dr[index + 1]);
            };
            var removeItem = function(index) {
                var Fields, DomString;
                Fields = UICnt.getFields();
                DomString = UICnt.getDOMString();
                UICnt.hideHeadAmountArea(Fields.get_dr[index + 1]);
                UICnt.setZero(Fields.get_dr[index + 1].querySelector('select'));
                UICnt.setEmpty(Fields.get_dr[index + 1].querySelector(DomString.amount));
            };
            return {
                init: function() {
                    console.log("App Is running");
                    setUpEventListner();
                    // Default hide fields
                    var Fields = UICnt.getFields();
                    var Values = UICnt.getValues();
                    UICnt.hide(Fields.get_cheque_number);
                    UICnt.hideHeadAmountArea(Fields.get_dr[1]);
                    UICnt.hideHeadAmountArea(Fields.get_dr[2]);
                    UICnt.hideHeadAmountArea(Fields.get_dr[3]);
                    UICnt.hideHeadAmountArea(Fields.get_dr[4]);
                    <?php if(!empty($item[1]->income_expense_head_id)): ?>
                        UICnt.showHeadAmountArea(Fields.get_dr[1]);
                    <?php endif; ?>
                    <?php if(!empty($item[2]->income_expense_head_id)): ?>
                        UICnt.showHeadAmountArea(Fields.get_dr[2]);
                    <?php endif; ?>
                    <?php if(!empty($item[3]->income_expense_head_id)): ?>
                        UICnt.showHeadAmountArea(Fields.get_dr[3]);
                    <?php endif; ?>
                    <?php if(!empty($item[4]->income_expense_head_id)): ?>
                        UICnt.showHeadAmountArea(Fields.get_dr[4]);
                    <?php endif; ?>
                    if (Values.bankcash_id <= 1) {
                        UICnt.hide(Fields.get_cheque_number);
                    } else {
                        UICnt.show(Fields.get_cheque_number);
                    }
                }
            }

        })(UiController);
        MainController.init();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eaccount\resources\views/admin/cr-voucher/edit.blade.php ENDPATH**/ ?>